package gov.va.med.domain.service.messaging.parse;

import ca.uhn.hl7v2.HL7Exception;

/**
 * IHL7ParseErrorListener
 * Callback interface is used to determine which segments should be parsed 
 * by HL7FilteringParser. Must be implemented by class that needs selective 
 * parsing.
 * <P>
 * Also used for callbacks to trap and process HL7 parser exceptions.
 * Must be implemented by class that needs lenient parsing of HL7 messsages.
 * 
 * @author Slava Uchitel
 * @version $Id: IHL7ParseErrorListener.java,v 1.3 2005/06/28 12:32:15 joel.goldberg Exp $
 * @since MHV 2.0 <br>03/16/2005
 */
public interface IHL7ParseErrorListener 
{ 
    /*
     *This method is called if segment parsing throws exception. 
     */
    public void onParseSegmentException(HL7ParseSegmentError error) 
        throws HL7Exception;
    
    /*
     *This method is called if field parsing throws exception. 
     */
    public void onParseFieldException(HL7ParseFieldError error) 
        throws HL7Exception;
    /*
     *This method is called if field parsing throws exception. 
     */
    public void onDecoderDataError(HL7DecoderDataError error) 
        throws  HL7Exception;
} 
